; Compiled with: PIC Simulator IDE v7.37
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
;       The value of 'max_servo' (global) is 1400
;       The value of 'min_servo' (global) is 400
;       The address of 'flashtime' (byte) (global) is 0x033
;       The address of 'flashdelay' (byte) (global) is 0x032
;       The address of 'servo_value' (word) (global) is 0x034
;       The address of 'direction' (byte) (global) is 0x036
;       The address of 'old_hall_a' (bit) (global) is 0x027,0
;       The address of 'old_hall_b' (bit) (global) is 0x027,2
;       The address of 'old_hall_c' (bit) (global) is 0x027,3
;       The address of 'old_hall_d' (bit) (global) is 0x027,1
;       The address of 'count_enter' (byte) (global) is 0x025
;       The address of 'count_exit' (byte) (global) is 0x024
;       The address of 'program' (byte) (global) is 0x026
;       The address of 'end_reached' (bit) (global) is 0x027,4
;       The address of 'dummy' (byte) (global) is 0x037
;       The address of 'onoff' (bit) (flashes) is 0x027,5
;       The address of 'hall_a' (bit) (global) is 0x005,6
;       The address of 'hall_b' (bit) (global) is 0x005,7
;       The address of 'hall_c' (bit) (global) is 0x005,0
;       The address of 'hall_d' (bit) (global) is 0x005,1
;       The address of 'servo_1' (bit) (global) is 0x006,5
;       The address of 'servo_2' (bit) (global) is 0x006,4
;       The address of 'rel' (bit) (global) is 0x006,1
;       The address of 'flash_1' (bit) (global) is 0x006,3
;       The address of 'flash_2' (bit) (global) is 0x006,2
;       The address of 'program_run' (bit) (global) is 0x006,0
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0007
	ORG 0x0004
	RETFIE
; User code start
L0007:
; 1: Define CONFIG = 0x3f50
; 2: 
; 3: 
; 4: 
; 5: 'program GCA186
; 6: 'railroad crossing controller for two directions
; 7: 
; 8: 'program option":
; 9: 'program = 0  idle task
; 10: '_         1  LEDS START FLASHING FOR 1.5 SECS AND SOUND IS SWItched on after time out program 2
; 11: '_         2  BARRIERS going down, wen down program 3
; 12: '_         3  waiting for counting down to zero, when zero program 4
; 13: '_         4  barriers going up, when up > program 5
; 14: '_         5  relay off, flashing off, waiting for last sensor to count tot zero, then program = 0
; 15: 
; 16: 
; 17: 
; 18: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 19: TRISA = %11111111
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
; 20: TRISB = %00000000
	CLRF TRISB
	BCF STATUS,RP0
; 21: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 22: PORTA = 255
	MOVLW 0xFF
	MOVWF PORTA
; 23: AllDigital
	MOVLW 0x07
	MOVWF CMCON
; 24: 
; 25: Symbol hall_a = RA6
; 26: Symbol hall_b = RA7
; 27: Symbol hall_c = RA0
; 28: Symbol hall_d = RA1
; 29: Symbol servo_1 = RB5
; 30: Symbol servo_2 = RB4
; 31: Symbol rel = RB1
; 32: Symbol flash_1 = RB3
; 33: Symbol flash_2 = RB2
; 34: Symbol program_run = RB0
; 35: 
; 36: Dim flashtime As Byte
	CLRF 0x033
; 37: Dim flashdelay As Byte
	CLRF 0x032
; 38: Dim servo_value As Word
	CLRF 0x034
	CLRF 0x035
; 39: Const max_servo = 1400
; 40: Const min_servo = 400
; 41: Dim direction As Byte
	CLRF 0x036
; 42: Dim old_hall_a As Bit
	BCF 0x027,0
; 43: Dim old_hall_b As Bit
	BCF 0x027,2
; 44: Dim old_hall_c As Bit
	BCF 0x027,3
; 45: Dim old_hall_d As Bit
	BCF 0x027,1
; 46: Dim count_enter As Byte
	CLRF 0x025
; 47: Dim count_exit As Byte
	CLRF 0x024
; 48: Dim program As Byte
	CLRF 0x026
; 49: Dim end_reached As Bit
	BCF 0x027,4
; 50: Dim dummy As Byte
	CLRF 0x037
; 51: 
; 52: servo_1 = 1
	BSF PORTB,5
; 53: servo_2 = 1
	BSF PORTB,4
; 54: servo_value = max_servo  'start in barrier up position
	MOVLW 0x78
	MOVWF 0x034
	MOVLW 0x05
	MOVWF 0x035
; 55: program = 0
	CLRF 0x026
; 56: old_hall_a = 0
	BCF 0x027,0
; 57: old_hall_b = 0
	BCF 0x027,2
; 58: old_hall_c = 0
	BCF 0x027,3
; 59: old_hall_d = 0
	BCF 0x027,1
; 60: count_exit = 0
	CLRF 0x024
; 61: count_enter = 0
	CLRF 0x025
; 62: flash_1 = 1
	BSF PORTB,3
; 63: flash_2 = 1
	BSF PORTB,2
; 64: flashdelay = 0
	CLRF 0x032
; 65: flashtime = 0
	CLRF 0x033
; 66: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 67: main:
L0001:
; 68: For dummy = 1 To 15
	MOVLW 0x01
	MOVWF 0x037
L0008:
	MOVF 0x037,W
	SUBLW 0x0F
	BTFSS STATUS,C
	GOTO L0009
; 69: Gosub check_sensors
	CALL L0003
; 70: WaitMs 1
	MOVLW 0x62
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
; 71: Next dummy
	MOVLW 0x01
	ADDWF 0x037,F
	BTFSS STATUS,C
	GOTO L0008
L0009:
; 72: program_run = 0
	BCF PORTB,0
; 73: If count_exit > 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0010
; 74: program_run = 1
	BSF PORTB,0
; 75: Endif
L0010:
; 76: Select Case program
; 77: Case 0  'idle task
	MOVF 0x026,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0011
; 78: count_enter = 0
	CLRF 0x025
; 79: count_exit = 0
	CLRF 0x024
; 80: end_reached = 1  'barriers are up
	BSF 0x027,4
; 81: Call flashes(0)
	BCF 0x027,5
	CALL L0002
; 82: direction = 0  'direction 1: first sensor =a  >>  direction =2 : first sensor = d
	CLRF 0x036
; 83: Case 1  'activate flashing leds and soundrelay
	GOTO L0012
L0011:
	MOVF 0x026,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0013
; 84: Call flashes(1)
	BSF 0x027,5
	CALL L0002
; 85: If flashtime > 12 Then  'enough flashing? start program 2
	MOVF 0x033,W
	SUBLW 0x0C
	BTFSC STATUS,C
	GOTO L0014
; 86: program = 2
	MOVLW 0x02
	MOVWF 0x026
; 87: Endif
L0014:
; 88: 
; 89: Case 2  'barriers down
	GOTO L0015
L0013:
	MOVF 0x026,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0016
; 90: Call barrier_down()
	CALL L0005
; 91: Call flashes(1)
	BSF 0x027,5
	CALL L0002
; 92: If end_reached = 0 Then
	BTFSC 0x027,4
	GOTO L0017
; 93: program = 3
	MOVLW 0x03
	MOVWF 0x026
; 94: Endif
L0017:
; 95: 
; 96: Case 3  'waiting for counting down count_enter
	GOTO L0018
L0016:
	MOVF 0x026,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0019
; 97: Call flashes(1)
	BSF 0x027,5
	CALL L0002
; 98: If count_enter = 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0020
; 99: program = 4
	MOVLW 0x04
	MOVWF 0x026
; 100: Endif
L0020:
; 101: Case 4  'barriers going up
	GOTO L0021
L0019:
	MOVF 0x026,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0022
; 102: Call barrier_up()
	CALL L0004
; 103: Call flashes(1)
	BSF 0x027,5
	CALL L0002
; 104: If end_reached = 1 Then
	BTFSS 0x027,4
	GOTO L0023
; 105: program = 5
	MOVLW 0x05
	MOVWF 0x026
; 106: Endif
L0023:
; 107: Case 5  'waiting for count down count_exit
	GOTO L0024
L0022:
	MOVF 0x026,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0025
; 108: Call flashes(1)
	BSF 0x027,5
	CALL L0002
; 109: If count_exit = 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0026
; 110: program = 0
	CLRF 0x026
; 111: Call flashes(0)
	BCF 0x027,5
	CALL L0002
; 112: flashtime = 0
	CLRF 0x033
; 113: flashdelay = 0
	CLRF 0x032
; 114: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	CALL W001
; 115: Endif
L0026:
; 116: Case Else
	GOTO L0027
L0025:
; 117: EndSelect
L0027:
L0024:
L0021:
L0018:
L0015:
L0012:
; 118: 
; 119: 
; 120: Goto main
	GOTO L0001
; 121: End
L0028:	GOTO L0028
; 122: Proc flashes(onoff As Bit)
L0002:
; 123: If onoff = 1 Then
	BTFSS 0x027,5
	GOTO L0029
; 124: If flashdelay < 20 Then
	MOVLW 0x14
	SUBWF 0x032,W
	BTFSC STATUS,C
	GOTO L0030
; 125: flashdelay = flashdelay + 1
	MOVF 0x032,W
	ADDLW 0x01
	MOVWF 0x032
; 126: Else
	GOTO L0031
L0030:
; 127: flashdelay = 0
	CLRF 0x032
; 128: flash_2 = flash_1
	BCF PORTB,2
	BTFSC PORTB,3
	BSF PORTB,2
; 129: flash_1 = Not flash_2
	BTFSS 0x006,2
	BSF 0x006,3
	BTFSC 0x006,2
	BCF 0x006,3
; 130: flashtime = flashtime + 1
	MOVF 0x033,W
	ADDLW 0x01
	MOVWF 0x033
; 131: Endif
L0031:
; 132: rel = 0  'sound on
	BCF PORTB,1
; 133: Else
	GOTO L0032
L0029:
; 134: flash_1 = 0  'leds off
	BCF PORTB,3
; 135: flash_2 = 0
	BCF PORTB,2
; 136: flashtime = 0
	CLRF 0x033
; 137: flashdelay = 0
	CLRF 0x032
; 138: rel = 1  'sound off
	BSF PORTB,1
; 139: Endif
L0032:
; 140: End Proc
	RETURN
; 141: 
; 142: check_sensors:
L0003:
; 143: Select Case direction
; 144: Case 0  'program = also still 0!
	MOVF 0x036,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0033
; 145: If hall_a = 0 Then
	BTFSC 0x005,6
	GOTO L0034
; 146: If old_hall_a = 0 Then
	BTFSC 0x027,0
	GOTO L0035
; 147: program = 1
	MOVLW 0x01
	MOVWF 0x026
; 148: direction = 1
	MOVLW 0x01
	MOVWF 0x036
; 149: count_enter = 1
	MOVLW 0x01
	MOVWF 0x025
; 150: count_exit = 1
	MOVLW 0x01
	MOVWF 0x024
; 151: old_hall_a = 1  'avoid the same been seen more than once in ome pass
	BSF 0x027,0
; 152: Endif
L0035:
; 153: Else
	GOTO L0036
L0034:
; 154: old_hall_a = 0
	BCF 0x027,0
; 155: Endif
L0036:
; 156: If hall_d = 0 Then
	BTFSC 0x005,1
	GOTO L0037
; 157: If old_hall_d = 0 Then
	BTFSC 0x027,1
	GOTO L0038
; 158: program = 1
	MOVLW 0x01
	MOVWF 0x026
; 159: direction = 2  'approach from other side
	MOVLW 0x02
	MOVWF 0x036
; 160: count_enter = 1
	MOVLW 0x01
	MOVWF 0x025
; 161: count_exit = 1
	MOVLW 0x01
	MOVWF 0x024
; 162: old_hall_d = 1  'avoid the same been seen more than once in ome pass
	BSF 0x027,1
; 163: Endif
L0038:
; 164: Else
	GOTO L0039
L0037:
; 165: old_hall_d = 0
	BCF 0x027,1
; 166: Endif
L0039:
; 167: 
; 168: Case 1  'forward from a to d
	GOTO L0040
L0033:
	MOVF 0x036,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0041
; 169: If hall_a = 0 Then
	BTFSC 0x005,6
	GOTO L0042
; 170: If old_hall_a = 0 Then
	BTFSC 0x027,0
	GOTO L0043
; 171: count_enter = count_enter + 1
	MOVF 0x025,W
	ADDLW 0x01
	MOVWF 0x025
; 172: count_exit = count_exit + 1
	MOVF 0x024,W
	ADDLW 0x01
	MOVWF 0x024
; 173: old_hall_a = 1  'avoid the same been seen more than once in ome pass
	BSF 0x027,0
; 174: Endif
L0043:
; 175: Else
	GOTO L0044
L0042:
; 176: old_hall_a = 0
	BCF 0x027,0
; 177: Endif
L0044:
; 178: If hall_c = 0 Then
	BTFSC 0x005,0
	GOTO L0045
; 179: If old_hall_c = 0 Then
	BTFSC 0x027,3
	GOTO L0046
; 180: If count_enter > 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0047
; 181: count_enter = count_enter - 1
	MOVLW 0x01
	SUBWF 0x025,W
	MOVWF 0x025
; 182: old_hall_c = 1  'avoid the same been seen more than once in ome pass
	BSF 0x027,3
; 183: Endif
L0047:
; 184: Endif
L0046:
; 185: Else
	GOTO L0048
L0045:
; 186: old_hall_c = 0
	BCF 0x027,3
; 187: Endif
L0048:
; 188: If hall_d = 0 Then
	BTFSC 0x005,1
	GOTO L0049
; 189: If old_hall_d = 0 Then
	BTFSC 0x027,1
	GOTO L0050
; 190: If count_exit > 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0051
; 191: count_exit = count_exit - 1
	MOVLW 0x01
	SUBWF 0x024,W
	MOVWF 0x024
; 192: old_hall_d = 1  'avoid the same been seen more than once in ome pass
	BSF 0x027,1
; 193: Endif
L0051:
; 194: Endif
L0050:
; 195: Else
	GOTO L0052
L0049:
; 196: old_hall_d = 0
	BCF 0x027,1
; 197: Endif
L0052:
; 198: Case Else  'reverse from d to a
	GOTO L0053
L0041:
; 199: If hall_d = 0 Then
	BTFSC 0x005,1
	GOTO L0054
; 200: If old_hall_d = 0 Then
	BTFSC 0x027,1
	GOTO L0055
; 201: count_enter = count_enter + 1
	MOVF 0x025,W
	ADDLW 0x01
	MOVWF 0x025
; 202: count_exit = count_exit + 1
	MOVF 0x024,W
	ADDLW 0x01
	MOVWF 0x024
; 203: old_hall_d = 1  'avoid the same been seen more than once in ome pass
	BSF 0x027,1
; 204: Endif
L0055:
; 205: Else
	GOTO L0056
L0054:
; 206: old_hall_d = 0
	BCF 0x027,1
; 207: Endif
L0056:
; 208: If hall_b = 0 Then
	BTFSC 0x005,7
	GOTO L0057
; 209: If old_hall_b = 0 Then
	BTFSC 0x027,2
	GOTO L0058
; 210: If count_enter > 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0059
; 211: count_enter = count_enter - 1
	MOVLW 0x01
	SUBWF 0x025,W
	MOVWF 0x025
; 212: old_hall_b = 1
	BSF 0x027,2
; 213: Endif
L0059:
; 214: Endif
L0058:
; 215: Else
	GOTO L0060
L0057:
; 216: old_hall_b = 0
	BCF 0x027,2
; 217: Endif
L0060:
; 218: If hall_a = 0 Then
	BTFSC 0x005,6
	GOTO L0061
; 219: If old_hall_a = 0 Then
	BTFSC 0x027,0
	GOTO L0062
; 220: If count_exit > 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0063
; 221: count_exit = count_exit - 1
	MOVLW 0x01
	SUBWF 0x024,W
	MOVWF 0x024
; 222: old_hall_a = 1
	BSF 0x027,0
; 223: Endif
L0063:
; 224: Endif
L0062:
; 225: Else
	GOTO L0064
L0061:
; 226: old_hall_a = 0
	BCF 0x027,0
; 227: Endif
L0064:
; 228: EndSelect
L0053:
L0040:
; 229: 
; 230: Return
	RETURN
; 231: 
; 232: Proc barrier_up()
L0004:
; 233: If servo_value < max_servo Then
	MOVF 0x034,W
	MOVWF R0L
	MOVF 0x035,W
	MOVWF R0H
	MOVLW 0x78
	MOVWF R1L
	MOVLW 0x05
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0065
; 234: servo_value = servo_value + 3
	MOVF 0x034,W
	ADDLW 0x03
	MOVWF 0x034
	MOVF 0x035,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x035
; 235: Call set_servo()
	CALL L0006
; 236: Else
	GOTO L0066
L0065:
; 237: end_reached = 1
	BSF 0x027,4
; 238: servo_1 = 1
	BSF PORTB,5
; 239: servo_2 = 1
	BSF PORTB,4
; 240: Exit
	RETURN
; 241: Endif
L0066:
; 242: End Proc
	RETURN
; 243: 
; 244: Proc barrier_down()
L0005:
; 245: If servo_value > min_servo Then
	MOVF 0x034,W
	MOVWF R0L
	MOVF 0x035,W
	MOVWF R0H
	MOVLW 0x90
	MOVWF R1L
	MOVLW 0x01
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0067
; 246: servo_value = servo_value - 3
	MOVLW 0x03
	SUBWF 0x034,W
	MOVWF 0x034
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x035,W
	MOVWF 0x035
; 247: Call set_servo()
	CALL L0006
; 248: Else
	GOTO L0068
L0067:
; 249: end_reached = 0
	BCF 0x027,4
; 250: servo_1 = 1
	BSF PORTB,5
; 251: servo_2 = 1
	BSF PORTB,4
; 252: Exit
	RETURN
; 253: Endif
L0068:
; 254: End Proc
	RETURN
; 255: 
; 256: Proc set_servo()
L0006:
; 257: servo_1 = 1
	BSF PORTB,5
; 258: WaitUs servo_value
	MOVF 0x034,W
	MOVWF R4L
	MOVF 0x035,W
	MOVWF R4H
	CALL Y001
; 259: servo_1 = 0
	BCF PORTB,5
; 260: servo_2 = 1
	BSF PORTB,4
; 261: WaitUs servo_value
	MOVF 0x034,W
	MOVWF R4L
	MOVF 0x035,W
	MOVWF R4H
	CALL Y001
; 262: servo_2 = 0
	BCF PORTB,4
; 263: End Proc
	RETURN
; 264: 
; End of user code
L0069:	GOTO L0069
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
; Waitus Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
;
;
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
